#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=167945 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144543, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.191]', '2024-11-30 10:57:00', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-30 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-30 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-30 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144970, 'Database Backup [database_backup_2024-12-01-00-02-02-v3-1-6.zip]', '2024-12-01 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (144999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-01 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-01 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-01 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145751, 'Database Backup [database_backup_2024-12-02-00-00-02-v3-1-6.zip]', '2024-12-02 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146313, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.191]', '2024-12-02 16:55:39', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146446, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-02 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146549, 'Database Backup [database_backup_2024-12-03-00-04-02-v3-1-6.zip]', '2024-12-03 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147342, 'Database Backup [database_backup_2024-12-04-00-04-02-v3-1-6.zip]', '2024-12-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147808, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.180]', '2024-12-04 14:22:25', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148130, 'Database Backup [database_backup_2024-12-05-00-03-02-v3-1-6.zip]', '2024-12-05 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:58:01', '[CRON]');
INSERT INTO `t