#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=118800 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:48:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:48:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:48:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:01:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:01:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:01:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-29 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-29 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-29 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95714, 'Database Backup [database_backup_2024-09-30-00-04-01-v3-1-6.zip]', '2024-09-30 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 06:58:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 06:58:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 06:58:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (95999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96402, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-09-30 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:26:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:26:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:26:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-30 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-30 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-30 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96511, 'Database Backup [database_backup_2024-10-01-00-05-02-v3-1-6.zip]', '2024-10-01 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (96999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97175, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.6]', '2024-10-01 19:53:15', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-01 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-01 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-01 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97314, 'Database Backup [database_backup_2024-10-02-00-02-03-v3-1-6.zip]', '2024-10-02 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 02:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 02:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 02:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97903, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.6]', '2024-10-02 17:45:19', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98111, 'Database Backup [database_backup_2024-10-03-00-04-01-v3-1-6.zip]', '2024-10-03 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98799, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-10-03 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98899, 'Database Backup [database_backup_2024-10-04-00-03-02-v3-1-6.zip]', '2024-10-04 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99224, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.6]', '2024-10-04 10:02:01', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log