#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=334606 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308741, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:05:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308745, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308749, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:17:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308753, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:22:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308757, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:28:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:34:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308761, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:34:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308765, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308769, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:45:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308773, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:50:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308777, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 04:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308781, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308785, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308789, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308793, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308797, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308801, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308805, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308809, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308813, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:48:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308817, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 05:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308821, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:00:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308825, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:06:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308829, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308833, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:18:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308837, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308841, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:29:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308845, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:35:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308849, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:40:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308853, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:46:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308857, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 06:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 06:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 06:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308861, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 06:58:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308865, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308869, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:10:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308873, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:16:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308877, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:22:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308881, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:27:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308885, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308889, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308893, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:44:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308897, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308901, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 07:56:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308905, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:02:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308909, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308913, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308917, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308921, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:24:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308925, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:30:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308929, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308933, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:41:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308937, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:47:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308941, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:52:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308945, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 08:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308949, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:03:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308953, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308957, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308961, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308965, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308969, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:32:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308973, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:38:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308977, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308981, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 09:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 09:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 09:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308985, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 09:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308989, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308993, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308997, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:12:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (308999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309001, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:18:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309005, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:24:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309009, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:29:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309013, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:35:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309017, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:40:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309021, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309025, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:51:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 10:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 10:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 10:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309029, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 10:56:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309033, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309037, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309041, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:13:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309045, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:19:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309049, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:25:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309053, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309057, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309061, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309065, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:47:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:52:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:52:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:52:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309069, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:52:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309073, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 11:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309077, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309081, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309085, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:15:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309089, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309093, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309097, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:32:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309101, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:38:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309105, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:44:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309109, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:50:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 12:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 12:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 12:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309113, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 12:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309117, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:02:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309121, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:08:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309125, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:13:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309129, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309133, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:25:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309137, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309141, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309145, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309149, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:48:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309153, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 13:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309157, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309161, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309165, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:11:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309169, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309173, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:22:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309177, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:27:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309181, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:33:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309185, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309189, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309193, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309197, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 14:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309201, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309205, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309209, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309213, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309217, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309221, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309225, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:38:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309229, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:44:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309233, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:50:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309237, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 15:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309241, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:01:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309245, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309249, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:12:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309253, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309257, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:23:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309261, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:29:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309265, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:35:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309269, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:40:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309273, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309277, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 16:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 16:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 16:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309281, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 16:57:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309285, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309289, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309293, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:14:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309297, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309301, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309305, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309309, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:36:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309313, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309317, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:47:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309321, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309325, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 17:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309329, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:05:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309333, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309337, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309341, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309345, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309349, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309353, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309357, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309361, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:51:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309365, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 18:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309369, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:02:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309373, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309377, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309381, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:20:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309385, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309389, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309393, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309397, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309401, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:48:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309405, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 19:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309409, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309413, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309417, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309421, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309425, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309429, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309433, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309437, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:40:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309441, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309445, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:52:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 20:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 20:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 20:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309449, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 20:57:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309453, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:03:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309457, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309461, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309465, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309469, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:27:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309473, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309477, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309481, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309485, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 21:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 21:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 21:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309489, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 21:56:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309493, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309497, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309501, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309505, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:18:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309509, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309513, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:30:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309517, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309521, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309525, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309529, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309533, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 22:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309537, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309541, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309545, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309549, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309553, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309557, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309561, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309565, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309569, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-22 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-22 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-22 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309573, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-22 23:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309577, 'Database Backup [database_backup_2025-06-23-00-04-05-v3-1-6.zip]', '2025-06-23 00:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309578, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309582, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309586, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309590, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309594, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309598, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309602, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309606, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:45:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309610, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309614, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 00:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309618, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309622, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309626, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:13:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309630, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309634, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309638, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309642, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309646, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:42:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309650, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309654, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 01:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309658, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309662, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309666, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309670, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309674, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309678, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309682, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309686, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309690, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309694, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 02:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309698, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 02:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309702, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309706, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309710, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309714, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309718, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309722, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309726, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309730, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309734, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309738, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:53:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 03:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 03:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 03:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309742, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 03:59:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309746, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309750, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309754, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309758, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:22:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309762, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309766, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309770, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309774, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309778, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309782, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 04:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309786, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309790, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309794, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:16:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309798, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309802, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:28:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309806, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309810, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:40:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309814, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309818, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:52:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 05:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 05:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 05:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309822, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 05:58:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309826, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309830, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309834, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:14:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309838, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309842, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309846, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:31:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309850, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309854, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309858, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309862, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 06:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 06:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 06:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309866, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 06:59:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309870, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:05:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309874, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309878, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309882, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309886, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309890, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309894, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:40:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309898, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309902, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 07:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 07:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 07:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309906, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 07:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309910, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309914, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309918, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309922, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:20:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309926, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309930, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309934, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309938, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309942, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:49:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 08:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 08:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 08:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309946, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 08:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309950, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309954, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309958, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309962, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309966, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309970, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309974, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309978, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309982, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309986, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 09:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309990, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309994, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309998, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (309999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310002, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310006, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:24:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310010, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:30:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310014, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310018, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310022, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:48:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310026, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 10:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 10:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 10:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310030, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 10:59:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310034, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310038, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:11:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310042, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310046, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310050, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310054, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310058, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310062, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310066, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:50:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 11:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 11:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 11:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310070, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 11:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310074, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310078, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310082, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310086, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310090, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:26:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310094, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:32:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310098, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:38:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310102, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:44:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310106, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310110, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 12:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310114, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:01:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310118, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:07:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310122, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:12:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310126, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:18:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310130, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310134, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310138, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310142, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:41:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310146, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310150, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310154, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 13:58:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310158, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310162, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310166, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:15:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310170, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310174, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:27:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310178, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:32:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310182, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:38:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310186, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310190, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 14:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 14:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 14:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310194, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 14:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310198, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310202, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310206, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310210, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:17:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310214, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310218, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310222, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310226, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:40:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310230, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310234, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 15:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310238, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 15:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310242, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310246, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310250, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310254, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:20:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310258, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310262, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:31:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310266, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310270, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310274, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 16:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 16:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 16:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310278, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 16:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310282, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310286, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310290, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310294, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310298, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310302, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310306, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:35:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310310, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310314, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310318, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 17:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 17:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 17:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310322, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 17:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310326, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310330, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310334, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:15:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310338, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310342, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310346, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:32:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310350, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310354, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310358, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 18:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 18:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 18:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310362, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 18:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310366, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310370, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310374, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310378, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310382, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310386, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310390, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310394, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310398, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310402, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310406, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 19:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310410, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310414, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310418, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310422, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310426, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310430, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310434, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310438, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310442, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310446, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 20:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310450, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310454, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310458, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310462, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310466, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310470, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310474, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310478, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310482, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310486, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310490, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 21:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310494, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310498, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310502, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310506, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310510, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:26:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310514, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310518, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:38:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310522, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310526, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 22:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 22:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 22:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310530, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 22:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310534, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310538, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310542, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310546, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310550, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310554, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:30:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310558, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310562, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310566, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-23 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-23 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-23 23:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310570, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-23 23:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310574, 'Database Backup [database_backup_2025-06-24-00-00-09-v3-1-6.zip]', '2025-06-24 00:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310575, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:00:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310579, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310583, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310587, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310591, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310595, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310599, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310603, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:39:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310607, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310611, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:50:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310615, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 00:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310619, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310623, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310627, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310631, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310635, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310639, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310643, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310647, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310651, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310655, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 01:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310659, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310663, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310667, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310671, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310675, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310679, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310683, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310687, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310691, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310695, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 02:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 02:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 02:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310699, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 02:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310703, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310707, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310711, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:15:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310715, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310719, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310723, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310727, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310731, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310735, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310739, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 03:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310743, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310747, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310751, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310755, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310759, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310763, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310767, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310771, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:40:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310775, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310779, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 04:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310783, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 04:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310787, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310791, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310795, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310799, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310803, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310807, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:33:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310811, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310815, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310819, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310823, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 05:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310827, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310831, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310835, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:13:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310839, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310843, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310847, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310851, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310855, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310859, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 06:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 06:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 06:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310863, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 06:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310867, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310871, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310875, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310879, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:19:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310883, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310887, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:30:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310891, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:35:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310895, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310899, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310903, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 07:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 07:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 07:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310907, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 07:58:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310911, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310915, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310919, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:15:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310923, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310927, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310931, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310935, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310939, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310943, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 08:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 08:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 08:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310947, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 08:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310951, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310955, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310959, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310963, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310967, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310971, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310975, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:35:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310979, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310983, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310987, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:52:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310991, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 09:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310995, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (310999, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311003, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:15:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311007, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311011, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311015, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311019, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311023, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311027, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:49:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 10:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 10:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 10:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311031, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 10:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311035, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311039, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311043, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311047, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311051, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311055, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311059, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311063, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311067, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311071, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:52:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311075, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 11:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311079, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311083, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311087, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:15:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311091, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311095, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311099, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311103, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311107, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311111, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:49:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 12:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 12:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 12:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311115, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 12:54:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311119, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311123, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:06:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311127, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311131, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311135, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:24:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311139, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311143, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311147, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311151, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311155, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 13:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311159, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311163, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311167, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:12:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311171, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311175, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:24:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311179, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:30:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311183, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311187, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:42:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311191, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:48:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311195, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 14:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 14:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 14:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311199, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 14:59:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311203, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311207, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:10:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311211, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311215, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311219, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311223, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:34:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311227, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:40:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311231, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:45:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311235, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:51:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 15:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 15:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 15:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311239, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 15:56:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311243, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:01:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:06:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:06:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:06:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311247, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:06:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311251, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:12:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311255, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:17:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311259, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311263, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:28:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311267, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:34:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311271, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:40:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311275, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:46:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311279, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:52:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 16:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 16:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 16:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311283, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 16:57:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311287, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311291, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:08:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311295, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311299, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:20:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311303, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:31:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:31:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:31:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311307, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:31:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311311, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311315, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:42:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311319, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311323, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:53:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 17:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 17:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 17:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311327, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 17:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311331, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:05:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311335, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:10:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311339, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311343, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311347, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:27:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311351, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:32:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311355, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311359, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311363, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:50:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 18:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 18:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 18:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311367, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 18:56:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311371, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311375, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:07:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311379, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:13:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311383, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311387, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311391, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:30:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311395, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:35:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311399, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311403, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311407, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311411, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 19:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311415, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:04:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311419, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:10:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311423, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:15:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311427, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:20:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311431, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311435, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311439, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:37:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311443, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:48:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:48:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:48:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311447, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:48:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 20:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 20:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 20:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311451, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 20:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311455, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:00:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311459, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311463, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:10:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311467, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:16:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311471, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:22:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:27:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:27:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:27:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311475, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:27:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311479, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:33:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:38:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:38:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:38:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311483, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:38:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:44:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:44:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:44:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311487, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:44:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311491, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 21:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 21:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 21:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311495, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 21:55:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311499, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311503, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:06:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311507, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:12:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:17:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:17:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:17:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311511, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:17:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311515, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311519, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:28:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:34:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:34:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:34:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311523, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:34:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311527, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:40:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311531, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311535, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311539, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 22:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311543, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 23:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311547, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 23:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311551, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 23:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311555, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 23:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311559, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 23:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311563, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 23:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311567, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 23:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311571, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 23:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311575, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 23:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-24 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-24 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-24 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311579, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-24 23:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311583, 'Database Backup [database_backup_2025-06-25-00-00-03-v3-1-6.zip]', '2025-06-25 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311584, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 00:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311588, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 00:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311592, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 00:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311596, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 00:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311600, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 00:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311604, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 00:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311608, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 00:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311612, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 00:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311616, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 00:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311620, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 00:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311624, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 00:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311628, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 01:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311632, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 01:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311636, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 01:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311640, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 01:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311644, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 01:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311648, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 01:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311652, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 01:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311656, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 01:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311660, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 01:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311664, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 01:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311668, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 02:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311672, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 02:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311676, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 02:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311680, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 02:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311684, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 02:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311688, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 02:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311692, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 02:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311696, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 02:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311700, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 02:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311704, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 02:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311708, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 03:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311712, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 03:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311716, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 03:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311720, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 03:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311724, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 03:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311728, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 03:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311732, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 03:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311736, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 03:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311740, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 03:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311744, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 03:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311748, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 03:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311752, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 04:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311756, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 04:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311760, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 04:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311764, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 04:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311768, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 04:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311772, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 04:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311776, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 04:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311780, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 04:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311784, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 04:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311788, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 04:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311792, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 05:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311796, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 05:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311800, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 05:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311804, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 05:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311808, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 05:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311812, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 05:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311816, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 05:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311820, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 05:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311824, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 05:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311828, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 05:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311832, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 06:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311836, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 06:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311840, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 06:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311844, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 06:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311848, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 06:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311852, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 06:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311856, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 06:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311860, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 06:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311864, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 06:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311868, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 06:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311872, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 06:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311876, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 07:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311880, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 07:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311884, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 07:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311888, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 07:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311892, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 07:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311896, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 07:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311900, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 07:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311904, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 07:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311908, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 07:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311912, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 07:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311916, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 08:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311920, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 08:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311924, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 08:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311928, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 08:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311932, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 08:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311936, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 08:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311940, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 08:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311944, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 08:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311948, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 08:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311952, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 08:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311956, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 08:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311960, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 09:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311964, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 09:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311968, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 09:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311972, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 09:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311976, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 09:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311980, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 09:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311984, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 09:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311988, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 09:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311992, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 09:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311996, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 09:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (311999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312000, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 09:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312004, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 10:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312008, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 10:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312012, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 10:15:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312016, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 10:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312020, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 10:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312024, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 10:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312028, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 10:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312032, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 10:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312036, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 10:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312040, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 10:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312044, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 11:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312048, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 11:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312052, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 11:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312056, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 11:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312060, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 11:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312064, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 11:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312068, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 11:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312072, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 11:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312076, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 11:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312080, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 11:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312084, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 11:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312088, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 12:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312092, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 12:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312096, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 12:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 12:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 12:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 12:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312100, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 12:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312104, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 12:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312108, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 12:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312112, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 12:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312116, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 12:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 12:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 12:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 12:49:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312120, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 12:49:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312124, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 12:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312128, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 13:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 13:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 13:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 13:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312132, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 13:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312136, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 13:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312140, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 13:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312144, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 13:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312148, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 13:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312152, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 13:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312156, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 13:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312160, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 13:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312164, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 13:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312168, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 14:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312172, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 14:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312176, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 14:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312180, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 14:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312184, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 14:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312188, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 14:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312192, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 14:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312196, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 14:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312200, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 14:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312204, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 14:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312208, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 14:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312212, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 15:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312216, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 15:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312220, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 15:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312224, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 15:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312228, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 15:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312232, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 15:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312236, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312240, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 15:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312244, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 15:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312248, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 15:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 16:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312252, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 16:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312256, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 16:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312260, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 16:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312264, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 16:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312268, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 16:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312272, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 16:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312276, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 16:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312280, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 16:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312284, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 16:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312288, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 16:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312292, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 17:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312296, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 17:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312300, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 17:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312304, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 17:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312308, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 17:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312312, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 17:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312316, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 17:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312320, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 17:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312324, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 17:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312328, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 17:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312332, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 17:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312336, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 18:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312340, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 18:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312344, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 18:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312348, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 18:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312352, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 18:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312356, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 18:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312360, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 18:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312364, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 18:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312368, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 18:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312372, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 18:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312376, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 19:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312380, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 19:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312384, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 19:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312388, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 19:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312392, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 19:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312396, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 19:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312400, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 19:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312404, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 19:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312408, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 19:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312412, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 19:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312416, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 19:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312420, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 20:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312424, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 20:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312428, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 20:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312432, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 20:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312436, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 20:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312440, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 20:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312444, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 20:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312448, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 20:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312452, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 20:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312456, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 20:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312460, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312464, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 21:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312468, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 21:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312472, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 21:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312476, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 21:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312480, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 21:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312484, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 21:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312488, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 21:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312492, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 21:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312496, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 21:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312500, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 21:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312504, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 22:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 22:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 22:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 22:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312508, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 22:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 22:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 22:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 22:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312512, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 22:14:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312516, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 22:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312520, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 22:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 22:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 22:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 22:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312524, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 22:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312528, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 22:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312532, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 22:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312536, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 22:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312540, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 22:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312544, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 22:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312548, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 23:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312552, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 23:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312556, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 23:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312560, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 23:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312564, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 23:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312568, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 23:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312572, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 23:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312576, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 23:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312580, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 23:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-25 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-25 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-25 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312584, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-25 23:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312588, 'Database Backup [database_backup_2025-06-26-00-03-03-v3-1-6.zip]', '2025-06-26 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312589, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 00:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312593, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 00:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312597, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 00:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312601, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 00:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312605, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 00:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312609, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 00:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312613, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 00:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312617, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 00:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312621, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 00:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312625, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 00:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312629, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 01:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312633, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 01:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312637, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 01:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312641, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 01:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312645, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 01:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312649, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 01:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312653, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 01:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312657, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 01:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312661, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 01:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312665, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 01:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312669, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 01:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312673, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 02:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312677, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 02:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312681, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 02:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312685, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 02:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312689, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 02:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312693, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 02:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312697, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 02:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312701, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 02:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312705, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 02:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312709, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 02:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312713, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 03:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312717, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 03:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312721, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 03:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312725, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 03:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312729, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 03:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312733, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 03:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312737, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 03:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 03:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 03:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 03:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312741, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 03:43:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312745, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 03:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312749, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 03:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312753, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312757, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312761, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312765, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312769, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312773, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312777, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312781, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312785, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312789, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312793, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 04:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312797, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312801, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312805, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312809, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312813, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312817, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312821, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312825, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312829, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312833, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 05:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312837, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312841, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312845, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312849, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312853, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312857, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312861, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312865, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312869, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312873, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312877, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 06:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312881, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312885, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312889, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312893, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312897, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312901, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312905, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312909, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312913, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312917, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312921, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 07:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312925, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312929, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312933, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312937, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312941, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312945, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312949, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312953, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312957, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312961, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 08:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312965, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312969, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312973, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312977, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312981, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312985, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312989, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312993, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312997, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (312999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313001, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 09:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313005, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313009, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313013, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313017, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313021, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313025, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313029, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313033, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313037, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313041, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313045, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 10:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313049, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313053, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313057, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313061, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313065, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313069, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313073, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313077, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313081, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313085, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313089, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 11:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313093, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313097, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313101, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313105, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313109, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313113, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313117, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313121, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313125, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313129, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 12:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313133, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313137, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313141, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313145, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313149, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313153, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313157, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313161, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313165, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313169, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313173, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 13:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313177, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313181, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313185, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313189, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313193, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:28:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313197, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313201, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313205, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313209, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313213, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 14:57:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313217, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313221, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313225, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313229, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313233, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313237, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313241, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313245, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313249, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313253, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 15:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313257, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313261, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313265, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313269, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313273, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:25:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313277, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313281, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313285, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313289, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313293, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 16:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313297, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313301, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313305, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313309, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313313, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313317, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313321, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-26 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-26 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313325, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-26 17:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (313327, 'Failed to