#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=102060 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (77999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78508, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.179]', '2024-09-08 19:13:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-08 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-08 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-08 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78668, 'Database Backup [database_backup_2024-09-09-00-00-04-v3-1-6.zip]', '2024-09-09 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (78999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 19:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 19:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 19:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 20:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 20:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 20:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79359, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-09-09 21:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 21:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 21:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 21:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79372, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.0]', '2024-09-09 21:18:08', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79373, 'Non Existing User Tried to Login [Email: bdallasferdinand@outlook.com, Is Staff Member: No, IP: 181.118.42.0]', '2024-09-09 21:19:12', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79374, 'New Lead Added [ID: 623]', '2024-09-09 21:21:45', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 22:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 22:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 22:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79465, 'Database Backup [database_backup_2024-09-10-00-02-02-v3-1-6.zip]', '2024-09-10 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 00:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 00:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 00:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 03:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 03:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 04:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 04:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 04:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 08:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 08:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 08:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 09:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 09:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 09:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 16:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 16:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (79999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 16:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 22:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 22:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 22:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 23:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 23:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 23:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-10 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-10 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-10 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80252, 'Database Backup [database_backup_2024-09-11-00-00-04-v3-1-6.zip]', '2024-09-11 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 00:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 00:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 01:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 01:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 01:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 01:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 01:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 01:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 01:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 01:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 01:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 02:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 02:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 02:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 03:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 10:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 10:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 10:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 11:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 11:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 11:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 13:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 13:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 13:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 14:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 14:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 14:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 15:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 15:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 15:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 15:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 15:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 15:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 16:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 16:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 16:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 19:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 19:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 19:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (80999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 22:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 22:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 22:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 22:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 22:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 22:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 23:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 23:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 23:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-11 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-11 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-11 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81054, 'Database Backup [database_backup_2024-09-12-00-03-02-v3-1-6.zip]', '2024-09-12 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 01:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 01:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 01:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 06:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 06:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 06:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 06:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 06:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 06:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 15:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 15:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 15:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 16:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 16:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 16:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 17:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 17:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 17:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 18:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 20:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 20:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 20:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81754, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-09-12 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 21:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 21:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 21:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-12 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-12 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-12 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81857, 'Database Backup [database_backup_2024-09-13-00-00-03-v3-1-6.zip]', '2024-09-13 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 02:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 02:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 02:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 03:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 03:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 03:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (81999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 05:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 05:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 05:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82140, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.171]', '2024-09-13 08:18:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82153, 'Invoice Deleted [INV-158/07/2024]', '2024-09-13 08:39:07', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82157, 'Invoice Status Updated [Invoice Number: INV-162/09/2024, From: Unpaid To: Paid]', '2024-09-13 08:44:03', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82158, 'Payment Recorded [ID:115, Invoice Number: INV-162/09/2024, Total: $2,520.00]', '2024-09-13 08:44:03', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82159, 'Email Sent To [Email: sealylewis@hotmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-09-13 08:44:09', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82160, 'Email Sent To [Email: support@saylesstt.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-09-13 08:44:12', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82161, 'Email Sent To [Email: sealylewis@hotmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-09-13 08:44:41', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82162, 'Email Sent To [Email: support@saylesstt.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-09-13 08:44:47', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 09:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 09:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 13:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 13:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 13:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-13 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-13 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (82460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-13 17:53:02', '[CRON]');
INSER