#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=345136 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321714, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321718, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321722, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321726, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321730, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321734, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321738, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321742, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321746, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321750, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 04:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321754, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321758, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321762, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321766, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:22:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321770, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321774, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321778, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321782, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321786, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321790, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 05:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321794, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321798, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321802, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321806, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321810, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321814, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321818, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321822, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321826, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321830, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 06:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321834, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321838, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321842, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321846, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321850, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321854, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321858, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321862, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321866, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321870, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 07:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321874, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321878, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321882, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321886, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:17:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321890, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321894, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321898, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321902, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321906, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321910, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321914, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 08:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321918, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321922, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:09:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321926, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321930, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321934, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321938, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:32:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321942, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321946, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321950, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321954, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 09:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321958, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321962, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321966, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321970, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321974, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321978, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321982, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321986, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:40:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321990, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321994, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321998, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 10:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (321999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322002, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322006, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322010, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322014, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:21:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322018, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322022, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322026, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322030, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322034, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322038, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 11:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322042, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322046, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322050, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322054, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322058, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322062, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322066, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322070, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322074, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322078, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322082, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 12:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322086, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322090, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322094, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322098, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322102, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:26:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322106, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:31:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322110, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322114, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322118, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322122, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322126, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 13:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322130, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322134, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322138, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322142, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322146, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:27:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322150, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322154, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322158, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322162, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 14:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 14:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 14:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322166, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 14:55:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322170, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:01:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322174, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322178, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:13:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322182, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322186, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322190, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322194, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:36:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322198, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322202, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322206, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322210, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 15:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322214, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322218, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:10:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322222, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322226, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322230, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322234, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322238, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322242, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322246, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322250, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 16:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322254, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322258, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322262, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322266, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:19:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322270, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322274, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322278, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322282, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322286, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322290, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 17:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322294, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322298, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322302, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:16:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:16:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:16:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322306, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:16:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322310, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322314, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322318, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322322, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322326, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322330, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322334, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 18:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322338, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322342, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322346, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:14:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322350, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:20:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322354, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322358, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:32:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322362, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322366, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322370, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322374, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 19:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322378, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322382, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322386, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:13:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322390, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:18:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322394, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322398, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322402, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322406, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322410, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322414, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322418, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 20:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322422, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322426, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322430, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322434, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322438, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322442, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322446, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322450, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322454, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322458, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 21:57:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322462, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322466, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322470, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322474, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322478, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:26:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322482, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322486, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322490, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322494, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322498, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 22:54:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322502, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322506, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322510, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:12:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322514, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322518, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322522, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322526, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322530, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322534, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322538, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-05 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-05 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-05 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322542, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-05 23:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322546, 'Database Backup [database_backup_2025-07-06-00-05-15-v3-1-6.zip]', '2025-07-06 00:05:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322547, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:05:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322551, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322555, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322559, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322560, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:a3c6:489f:cfff:3527]', '2025-07-06 00:25:19', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322561, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:a3c6:489f:cfff:3527]', '2025-07-06 00:25:50', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322562, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:a3c6:489f:cfff:3527]', '2025-07-06 00:26:20', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322563, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:a3c6:489f:cfff:3527]', '2025-07-06 00:26:46', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322567, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322571, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:33:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322575, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322579, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322583, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322587, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 00:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322591, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 01:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322595, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 01:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322599, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 01:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322603, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 01:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322607, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 01:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322611, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-07-06 01:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322612, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:a3c6:489f:cfff:3527]', '2025-07-06 01:39:44', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322613, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:a3c6:489f:cfff:3527]', '2025-07-06 01:40:08', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322977, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:e902:2b2a:f8dd:458]', '2025-07-06 13:16:54', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322978, 'Project Deleted [ID: 43, Name: Starter Website and Video Ad]', '2025-07-06 13:20:00', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322982, 'Project Deleted [ID: 47, Name: Website, Branding and Adroid and IOS Apps]', '2025-07-06 13:20:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322983, 'Task Attachment Deleted [TaskID: 159]', '2025-07-06 13:20:08', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322984, 'Project Deleted [ID: 22, Name: Business Website]', '2025-07-06 13:20:08', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322985, 'Project Deleted [ID: 23, Name: Ecommerce Website]', '2025-07-06 13:20:11', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322986, 'Project Deleted [ID: 24, Name: The Vegas Carnival]', '2025-07-06 13:20:14', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322987, 'Project Deleted [ID: 25, Name: Website Design]', '2025-07-06 13:20:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322988, 'Project Deleted [ID: 26, Name: Room Bookings Website]', '2025-07-06 13:20:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322989, 'Project Deleted [ID: 27, Name: Real Estate Booking Website]', '2025-07-06 13:20:23', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322990, 'Contract Deleted [17]', '2025-07-06 13:21:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322991, 'Contract Deleted [16]', '2025-07-06 13:21:08', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322992, 'Contract Deleted [12]', '2025-07-06 13:21:12', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322993, 'Contract Deleted [23]', '2025-07-06 13:21:16', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322994, 'Contract Deleted [2]', '2025-07-06 13:21:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (322999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323082, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:4470:3e1:d405:bc4d]', '2025-07-06 16:08:56', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323236, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-06 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323237, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-07-06 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323238, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-07-06 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-06 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-06 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-06 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323335, 'Database Backup [database_backup_2025-07-07-00-03-03-v3-3-1.zip]', '2025-07-07 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323822, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:cc9e:e2f5:f4c8:c6ba]', '2025-07-07 15:47:51', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323823, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:cc9e:e2f5:f4c8:c6ba]', '2025-07-07 15:47:51', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323986, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-07 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324080, 'Database Backup [database_backup_2025-07-08-00-03-02-v3-3-1.zip]', '2025-07-08 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324366, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:cc9e:e2f5:f4c8:c6ba]', '2025-07-08 09:18:03', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324370, 'Email Sent To [Email: naresh.sookhan@gmail.com, Template: Send Invoice to Customer]', '2025-07-08 09:24:41', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324830, 'Database Backup [database_backup_2025-07-09-00-01-06-v3-3-1.zip]', '2025-07-09 00:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324888, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:e46b:ac35:ac80:6a7e]', '2025-07-09 01:55:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324889, 'Non Existing User Tried to Login [Email: admin@saylessdigital.io, Is Staff Member: No, IP: 2803:1500:1c00:95cc:e46b:ac35:ac80:6a7e]', '2025-07-09 01:55:37', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:57:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:57:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325493, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-09 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325494, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-07-09 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325495, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-07-09 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325595, 'Database Backup [database_backup_2025-07-10-00-03-02-v3-3-1.zip]', '2025-07-10 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:23:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:23:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:23:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:46:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:46:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, 