#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=348908 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326250, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-10 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326350, 'Database Backup [database_backup_2025-07-11-00-02-18-v3-3-1.zip]', '2025-07-11 00:02:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:26:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:26:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:26:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327002, 'Email Sent To [Email: naresh.sookhan@gmail.com, Template: Invoice Due Notice]', '2025-07-11 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327099, 'Database Backup [database_backup_2025-07-12-00-02-02-v3-3-1.zip]', '2025-07-12 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327748, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-12 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327749, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-07-12 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327750, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-07-12 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327751, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Send Invoice to Customer]', '2025-07-12 21:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327752, 'Email sent to: tishara.f@saylesstt.com Subject: Recurring Invoices Cron Job Activity', '2025-07-12 21:05:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327753, 'Email sent to: clientportal@saylesstt.com Subject: Recurring Invoices Cron Job Activity', '2025-07-12 21:05:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327754, 'Email sent to: dallas.f@saylesstt.com Subject: Recurring Invoices Cron Job Activity', '2025-07-12 21:05:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:05:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:05:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:05:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327848, 'Database Backup [database_backup_2025-07-13-00-00-03-v3-3-1.zip]', '2025-07-13 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 03:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 03:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 03:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 16:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 16:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 16:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328500, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-13 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 21:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 21:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 21:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328594, 'Database Backup [database_backup_2025-07-14-00-01-02-v3-3-1.zip]', '2025-07-14 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 02:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 02:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 02:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (328999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329252, 'Invoice Status Updated [Invoice Number: INV-177/07/2025, From: Unpaid To: Overdue]', '2025-07-14 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329253, 'Email Sent To [Email: naresh.sookhan@gmail.com, Template: Invoice Overdue Notice]', '2025-07-14 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-14 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-14 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-14 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329350, 'Database Backup [database_backup_2025-07-15-00-00-03-v3-3-1.zip]', '2025-07-15 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:27:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (329999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330008, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-15 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330009, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-07-15 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330010, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-07-15 21:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330011, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Due Notice]', '2025-07-15 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-15 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-15 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-15 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330108, 'Database Backup [database_backup_2025-07-16-00-03-03-v3-3-1.zip]', '2025-07-16 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-16 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-16 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-16 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (330161, 'Failed to connect to IMAP auto importing tic