#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=298039 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274015, 'Database Backup [database_backup_2025-05-10-00-02-04-v3-1-6.zip]', '2025-05-10 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:39:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:39:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:39:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 15:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 15:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 15:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 16:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 16:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 16:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 16:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 16:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 16:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 16:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 16:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 16:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 16:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 16:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 16:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 17:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 17:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 17:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274742, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-10 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274743, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-05-10 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274804, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:16ba:a258:a264:edd8]', '2025-05-10 22:35:16', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274853, 'Database Backup [database_backup_2025-05-11-00-02-04-v3-1-6.zip]', '2025-05-11 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 01:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 01:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 01:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 02:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275544, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-11 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275647, 'Database Backup [database_backup_2025-05-12-00-04-03-v3-1-6.zip]', '2025-05-12 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276215, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:d62:d979:8b6b:7f65]', '2025-05-12 15:52:53', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276216, 'Non Existing User Tried to Login [Email: saylesstt@gmail.com, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:d62:d979:8b6b:7f65]', '2025-05-12 15:53:05', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276217, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:16ba:a258:a264:edd8]', '2025-05-12 15:53:38', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276218, 'Invoice Status Updated [Invoice Number: INV-168/12/2024, From: Overdue To: Paid]', '2025-05-12 15:54:28', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276219, 'Payment Recorded [ID:125, Invoice Number: INV-168/12/2024, Total: $1,449.00]', '2025-05-12 15:54:28', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276220, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-05-12 15:54:35', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276488, 'Database Backup [database_backup_2025-05-13-00-00-04-v3-1-6.zip]', '2025-05-13 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277194, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-13 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277195, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Due Notice]', '2025-05-13 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277196, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Due Notice]', '2025-05-13 21:04:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:04:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:04:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:04:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277299, 'Database Backup [database_backup_2025-05-14-00-04-04-v3-1-6.zip]', '2025-05-14 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277778, 'Failed to connect to IMAP auto 