#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=141065 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (116999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117200, 'Database Backup [database_backup_2024-10-27-00-02-01-v3-1-6.zip]', '2024-10-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 15:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 15:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 15:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 20:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 20:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 20:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117894, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-10-27 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117895, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-10-27 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 23:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 23:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 23:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-27 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-27 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-27 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (117999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118001, 'Database Backup [database_backup_2024-10-28-00-01-03-v3-1-6.zip]', '2024-10-28 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 00:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 00:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 00:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 18:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 18:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 18:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-28 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-28 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-28 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118800, 'Database Backup [database_backup_2024-10-29-00-04-03-v3-1-6.zip]', '2024-10-29 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118972, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.138]', '2024-10-29 05:15:50', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (118999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 17:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 17:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 17:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-29 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119591, 'Database Backup [database_backup_2024-10-30-00-01-03-v3-1-6.zip]', '2024-10-30 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:07:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:07:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:07:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120282, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-10-30 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120283, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-10-30 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120386, 'Database Backup [database_backup_2024-10-31-00-04-02-v3-1-6.zip]', '2024-10-31 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:26:02', '[CRON]');
INSERT INTO `tblactivity_l