#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=75389 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52338, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.63]', '2024-08-05 18:03:58', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52366, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.63]', '2024-08-05 18:59:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52412, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 181.118.42.63]', '2024-08-05 20:27:58', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52422, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 20:44:06', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52423, 'Email Sent To [Email: brinsley.smith@lobaxtt.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 20:44:06', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52424, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 20:44:12', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52425, 'Email Sent To [Email: brinsley.smith@lobaxtt.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 20:44:13', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52429, 'User Successfully Logged In [User Id: 2, Is Staff Member: No, IP: 2604:3d09:e072:b700:44f3:1133:dd99:7c0e]', '2024-08-05 20:49:50', 'Al Jones ');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52430, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Comment on Task (Sent to Staff)]', '2024-08-05 20:50:10', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52431, 'Email Sent To [Email: livinglovelly@gmail.com, Template: New Comment on Task (Sent to Customer Contacts)]', '2024-08-05 20:50:10', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52432, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 20:50:55', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52433, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 20:50:55', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52434, 'Project Updated [ID: 25]', '2024-08-05 20:53:16', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52438, 'Project Updated [ID: 24]', '2024-08-05 20:55:57', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52439, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-08-05 20:59:42', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52440, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-08-05 20:59:42', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52441, 'New Task Added [ID:232, Name: First draft]', '2024-08-05 20:59:42', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52445, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-08-05 21:00:17', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52446, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-08-05 21:00:17', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52447, 'New Task Added [ID:233, Name: second draft]', '2024-08-05 21:00:17', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52448, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 21:00:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52449, 'Email Sent To [Email: keripatrick@me.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:00:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52450, 'Email Sent To [Email: claireclottey@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:00:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52451, 'Email Sent To [Email: candice.imam@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:00:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52452, 'Email Sent To [Email: chersmm868@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:00:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52453, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-08-05 21:01:23', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52454, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-08-05 21:01:23', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52455, 'New Task Added [ID:234, Name: Third draft]', '2024-08-05 21:01:23', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52456, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 21:02:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52457, 'Email Sent To [Email: keripatrick@me.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:02:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52458, 'Email Sent To [Email: claireclottey@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:02:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52459, 'Email Sent To [Email: candice.imam@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:02:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52460, 'Email Sent To [Email: chersmm868@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:02:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52461, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-08-05 21:03:16', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52462, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-08-05 21:03:17', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52463, 'New Task Added [ID:235, Name: Reviews draft]', '2024-08-05 21:03:17', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52464, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 21:03:26', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52465, 'Email Sent To [Email: keripatrick@me.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:03:27', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52466, 'Email Sent To [Email: claireclottey@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:03:27', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52467, 'Email Sent To [Email: candice.imam@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:03:27', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52468, 'Email Sent To [Email: chersmm868@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:03:27', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52469, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-08-05 21:04:15', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52470, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-08-05 21:04:15', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52471, 'New Task Added [ID:236, Name: Final draft (website complete)]', '2024-08-05 21:04:15', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52472, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 21:04:29', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52473, 'Email Sent To [Email: keripatrick@me.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:04:29', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52474, 'Email Sent To [Email: claireclottey@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:04:29', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52475, 'Email Sent To [Email: candice.imam@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:04:29', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52476, 'Email Sent To [Email: chersmm868@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:04:29', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52477, 'Task Updated [ID:233, Name: Second draft]', '2024-08-05 21:04:51', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52481, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-08-05 21:08:34', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52482, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-08-05 21:08:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52483, 'New Task Added [ID:237, Name: Hand over]', '2024-08-05 21:08:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52484, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 21:08:45', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52485, 'Email Sent To [Email: keripatrick@me.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:08:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52486, 'Email Sent To [Email: claireclottey@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:08:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52487, 'Email Sent To [Email: candice.imam@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:08:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52488, 'Email Sent To [Email: chersmm868@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:08:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52492, 'User Successfully Logged In [User Id: 88, Is Staff Member: No, IP: 2607:fb90:73aa:442e:bda4:1704:42c:3318]', '2024-08-05 21:13:40', 'Claire Clottey');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52580, 'Database Backup [database_backup_2024-08-06-00-01-03-v3-1-6.zip]', '2024-08-06 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53313, 'Database Backup [database_backup_2024-08-07-00-02-03-v3-1-6.zip]', '2024-08-07 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53662, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.161]', '2024-08-07 11:41:15', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53666, 'Invoice Status Updated [Invoice Number: INV-139/06/2024, From: Partially Paid To: Paid]', '2024-08-07 11:42:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53667, 'Payment Recorded [ID:108, Invoice Number: INV-139/06/2024, Total: $1,000.00]', '2024-08-07 11:42:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53668, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-08-07 11:42:42', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53669, 'Email Sent To [Email: tishara.f@saylesstt.com, Template: Invoice Payment Recorded (Sent to Staff)]', '2024-08-07 11:42:44', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53670, 'Invoice Status Updated [Invoice Number: INV-107/03/2024, From: Partially Paid To: Paid]', '2024-08-07 11:44:44', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53671, 'Payment Recorded [ID:109, Invoice Number: INV-107/03/2024, Total: $2,000.00]', '2024-08-07 11:44:44', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53672, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-08-07 11:44:54', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53673, 'Email Sent To [Email: tishara.f@saylesstt.com, Template: Invoice Payment Recorded (Sent to Staff)]', '2024-08-07 11:44:57', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53737, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.161]', '2024-08-07 13:52:29', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53954, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-08-07 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (53999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-07 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-07 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-07 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54048, 'Database Backup [database_backup_2024-08-08-00-02-02-v3-1-6.zip]', '2024-08-08 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54685, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.161]', '2024-08-08 21:19:32', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-08 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-08 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-08 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54770, 'Database Backup [database_backup_2024-08-09-00-02-02-v3-1-6.zip]', '2024-08-09 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (54999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55293, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.161]', '2024-08-09 17:31:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55297, 'Email Sent To [Email: sealylewis@hotmail.com, Template: Send Invoice to Customer]', '2024-08-09 17:36:07', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55298, 'Email Sent To [Email: support@saylesstt.com, Template: Send Invoice to Customer]', '2024-08-09 17:36:10', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55494, 'Database Backup [database_backup_2024-08-10-00-02-02-v3-1-6.zip]', '2024-08-10 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55831, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.161]', '2024-08-10 11:18:49', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55832, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.161]', '2024-08-10 11:18:49', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (55999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56040, 'Invoice Status Updated [Invoice Number: INV-161/08/2024, From: Unpaid To: Paid]', '2024-08-10 18:09:09', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56041, 'Payment Recorded [ID:110, Invoice Number: INV-161/08/2024, Total: $210.00]', '2024-08-10 18:09:09', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56042, 'Email Sent To [Email: sealylewis@hotmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-08-10 18:09:18', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56043, 'Email Sent To [Email: support@saylesstt.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-08-10 18:09:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56128, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-08-10 21:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-10 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-10 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-10 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56222, 'Database Backup [database_backup_2024-08-11-00-02-02-v3-1-6.zip]', '2024-08-11 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (56370, 'Failed to connect to IMAP