#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=184684 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160709, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-20 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160710, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2024-12-20 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-20 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-20 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-20 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160810, 'Database Backup [database_backup_2024-12-21-00-05-02-v3-1-6.zip]', '2024-12-21 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (160999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-21 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-21 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-21 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161615, 'Database Backup [database_backup_2024-12-22-00-04-02-v3-1-6.zip]', '2024-12-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162402, 'Database Backup [database_backup_2024-12-23-00-03-03-v3-1-6.zip]', '2024-12-23 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163087, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-23 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163088, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2024-12-23 21:00:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:00:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:00:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:00:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163194, 'Database Backup [database_backup_2024-12-24-00-01-03-v3-1-6.zip]', '2024-12-24 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163324, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.3]', '2024-12-24 04:02:53', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163979, 'Database Backup [database_backup_2024-12-25-00-04-02-v3-1-6.zip]', '2024-12-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `descript